var clock = 0;

function UpdateClock() {
	if (clock) {
		clearTimeout(clock);
		clock = 0;
	}
	document.getElementById('clock').innerHTML = ReplaceNumbers(GetTime());
	clock = setTimeout("UpdateClock()", 1000);
}

function StartClock() {
	clock = setTimeout("UpdateClock()", 500);
}

function GetTime(){
	var tDate = new Date();
	hour = ''+tDate.getHours();
	minutes = ''+tDate.getMinutes();
	seconds = ''+tDate.getSeconds();
	if (hour.length == 1) hour = '0'+hour;
	if (minutes.length == 1) minutes = '0'+minutes;
	if (seconds.length == 1) seconds = '0'+seconds;
	return hour+':'+minutes+':'+seconds;
}

function ReplaceNumbers(string){
	string = string.replace(/0/g,'<img src="/clock/0.png" alt="0"/>');
	string = string.replace(/1/g,'<img src="/clock/1.png" alt="1"/>');
	string = string.replace(/2/g,'<img src="/clock/2.png" alt="2"/>');
	string = string.replace(/3/g,'<img src="/clock/3.png" alt="3"/>');
	string = string.replace(/4/g,'<img src="/clock/4.png" alt="4"/>');
	string = string.replace(/5/g,'<img src="/clock/5.png" alt="5"/>');
	string = string.replace(/6/g,'<img src="/clock/6.png" alt="6"/>');
	string = string.replace(/7/g,'<img src="/clock/7.png" alt="7"/>');
	string = string.replace(/8/g,'<img src="/clock/8.png" alt="8"/>');
	string = string.replace(/9/g,'<img src="/clock/9.png" alt="9"/>');
	string = string.replace(/:/g,'<img src="/clock/colon.png" alt=":"/>');
	return string;
}

function KillClock() {
	if (clock) {
		clearTimeout(clock);
		clock = 0;
	}
}